/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.client.model.inventory;

import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.List;
import net.minecraft.class_3518;
import net.minecraft.class_811;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import slimeknights.mantle.client.model.util.ModelHelper;
import slimeknights.mantle.util.JsonHelper;

public class ModelItem {
    private static final ModelItem EMPTY = new ModelItem(new Vector3f(0.0f, 0.0f, 0.0f), 0.0f, 0.0f, 0.0f);
    private final Vector3f center;
    private final float size;
    private final float x;
    private final float y;
    private final class_811 transform;
    private Vector3f centerScaled;
    private Float sizeScaled;

    public ModelItem(Vector3f center, float size, float x, float y) {
        this(center, size, x, y, class_811.field_4315);
    }

    public ModelItem(Vector3f center, float size, float x, float y, class_811 transform) {
        this.center = center;
        this.size = size;
        this.x = x;
        this.y = y;
        this.transform = transform;
    }

    public Vector3f getCenterScaled() {
        if (this.centerScaled == null) {
            this.centerScaled = new Vector3f((Vector3fc)this.center);
            this.centerScaled.mul(0.0625f);
        }
        return this.centerScaled;
    }

    public float getSizeScaled() {
        if (this.sizeScaled == null) {
            this.sizeScaled = Float.valueOf(this.size / 16.0f);
        }
        return this.sizeScaled.floatValue();
    }

    public boolean isHidden() {
        return this.size == 0.0f;
    }

    private static class_811 parseTransformType(JsonObject json, String key) {
        String name;
        switch (name = class_3518.method_15253((JsonObject)json, (String)key, (String)"none")) {
            case "none": {
                return class_811.field_4315;
            }
            case "head": {
                return class_811.field_4316;
            }
            case "gui": {
                return class_811.field_4317;
            }
            case "ground": {
                return class_811.field_4318;
            }
            case "fixed": {
                return class_811.field_4319;
            }
            case "thirdperson_righthand": {
                return class_811.field_4320;
            }
            case "thirdperson_lefthand": {
                return class_811.field_4323;
            }
            case "firstperson_righthand": {
                return class_811.field_4322;
            }
            case "firstperson_lefthand": {
                return class_811.field_4321;
            }
        }
        throw new JsonSyntaxException("Unknown transform type " + name);
    }

    public static ModelItem fromJson(JsonObject json) {
        float size = class_3518.method_15259((JsonObject)json, (String)"size");
        if (size == 0.0f) {
            return EMPTY;
        }
        Vector3f center = ModelHelper.arrayToVector(json, "center");
        float x = ModelHelper.getRotation(json, "x");
        float y = ModelHelper.getRotation(json, "y");
        class_811 transformType = ModelItem.parseTransformType(json, "transform");
        return new ModelItem(center, size, x, y, transformType);
    }

    public static List<ModelItem> listFromJson(JsonObject parent, String key) {
        return JsonHelper.parseList(parent, key, ModelItem::fromJson);
    }

    public Vector3f getCenter() {
        return this.center;
    }

    public float getSize() {
        return this.size;
    }

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }

    public class_811 getTransform() {
        return this.transform;
    }
}

